#include "singlethreaded/lenvechashvecngramer.hpp"
#include "util/shared.hpp"
#include <algorithm>
#include <iostream>
#include <iterator>
#include <sstream>
#include <unordered_set>

void STLenVecHashVecNgramer::query(const BorrowedString& document, QueryOut& out)
{
   processStringSplits(document, ' ', [&out, this](const BorrowedString& full, const BorrowedString& prefix,
                                                   const BorrowedString& remainder) {
      auto prefixLen = prefix.size();
      if (prefixLen < ngrams.size() && !ngrams[prefixLen].empty()) {
         auto indexIt = ngrams[prefixLen].find(prefix.toOwnedRef());
         if (indexIt != ngrams[prefixLen].end()) {
            auto& index = indexIt->second;
            auto before = index.begin();
            for (auto i = before; i != index.end(); i++) {
               const auto& value = *i;
               if ((value.size() > remainder.size()) || (value != remainder.substr(0, value.size()).toOwnedRef())) {
                  continue;
               }
               if (((remainder.size() == (value.size())) || (remainder[value.size()] == ' '))) {
                  auto result = full.substr(0, prefix.size() + value.size());
                  if (found.find(result) == found.end()) {
                     found.insert(result);
                     out.addNgram(result);
                  }
               }
            }
         }
      }
   });

   found.clear();
   out.finishResult();
}

void STLenVecHashVecNgramer::add(const BorrowedString& ngram)
{
   auto tokens = ngram.split(' ');
   auto prefixLen = tokens.first.size();
   if (prefixLen >= ngrams.size()) {
      ngrams.resize(prefixLen * 2);
   }

   auto match = ngrams[prefixLen].find(tokens.first.toOwnedRef());
   if (match == ngrams[prefixLen].end()) {
      ngrams[prefixLen][std::move(tokens.first.toOwned())].emplace_back(std::move(tokens.second.toOwned()));
   }
   else {
      match->second.emplace_back(std::move(tokens.second.toOwned()));
      std::sort(match->second.begin(), match->second.end());
   }
}

void STLenVecHashVecNgramer::remove(const BorrowedString& ngram)
{
   auto tokens = ngram.split(' ');
   auto prefixLen = tokens.first.size();

   auto match = ngrams[prefixLen].find(tokens.first.toOwnedRef());
   if (match != ngrams[prefixLen].end()) {
      match->second.erase(std::remove(match->second.begin(), match->second.end(), tokens.second.toOwnedRef()),
                          match->second.end());
      if (match->second.empty()) {
         ngrams[prefixLen].erase(match);
      }
   }
}
