#include "singlethreaded/hashvecngramer.hpp"
#include "util/shared.hpp"
#include <algorithm>
#include <iostream>
#include <iterator>
#include <sstream>
#include <unordered_set>

void STHashVecNgramer::query(const BorrowedString& document, QueryOut& out)
{
   processStringSplits(document, ' ',
                       [&out, this](const BorrowedString& full, const BorrowedString& prefix, const BorrowedString& remainder) {
                          auto indexIt = ngrams.find(prefix);
                          if (indexIt != ngrams.end()) {
                             auto& index = indexIt->second;
                             auto before = index.begin();
                             for (auto i = before; i != index.end(); i++) {
                                const auto& value = *i;
                                if (value.first.size() > remainder.size()) {
                                   continue;
                                }
                                if (value.first.size() != remainder.size() && remainder[value.first.size()] != ' ') {
                                   continue;
                                }
                                if (value.first != remainder.substr(0, value.first.size())) {
                                   continue;
                                }
                                auto result = full.substr(0, prefix.size() + value.first.size());
                                if (!found[value.second]) {
                                   clear.push_back(value.second);
                                   found[value.second] = true;
                                   out.addNgram(result);
                                }
                             }
                          }
                       });

   if (clear.size() < found.size() / 6) {
      for (auto& entry : clear) {
         found[entry] = false;
      }
   }
   else {
      found.clear();
   }
   clear.clear();
   out.finishResult();
}

template <typename T, typename Pred>
typename std::vector<T>::iterator insert_sorted(std::vector<T>& vec, T const& item, Pred pred)
{
   return vec.insert(std::upper_bound(vec.begin(), vec.end(), item, pred), item);
}

typedef std::pair<BorrowedString, size_t> ValPair;

void STHashVecNgramer::add(const BorrowedString& ngram)
{
   auto index = ngramStore.size();
   ngramStore.emplace_back(ngram.toOwned());
   found.resize(ngramStore.size());

   auto tokens = BorrowedString::fromOwned(ngramStore[index]).split(' ');

   auto match = ngrams.find(tokens.first);
   if (match == ngrams.end()) {
      ngrams[tokens.first].emplace_back(tokens.second, index);
   }
   else {
      // match->second.emplace_back(tokens.second,index);
      insert_sorted(match->second, std::make_pair(tokens.second, index),
                    [](const ValPair& a, const ValPair& b) { return a.first.size() < b.first.size(); });
   }
}


void STHashVecNgramer::remove(const BorrowedString& ngram)
{
   auto tokens = ngram.split(' ');

   auto match = ngrams.find(tokens.first);
   if (match != ngrams.end()) {
      match->second.erase(std::remove_if(match->second.begin(), match->second.end(),
                                         [&tokens](const ValPair& a) { return a.first == tokens.second; }),
                          match->second.end());
      if (match->second.empty()) {
         ngrams.erase(tokens.first);
      }
   }
}

void STHashVecNgramer::finalizeLoading()
{
   ngrams.grow();
   ngrams.grow();
   found.reserve(found.size() * 3);
   clear.reserve(clear.size() * 3);
   ngramStore.reserve(ngramStore.size() * 3);
}
