#!/bin/bash

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
cd "$DIR"

if [ "$#" -ne 1 ]; then
    echo "Error: Invalid number of parameters"
    echo "Usage: ./bench_local.sh <workload_file>"
    exit 1
fi

INPUT="$1"

./compile.sh || exit 1
for variant in $( build/Release/driver/driver_runner );
do
   echo "Benchmarking $variant"
   for i in $(echo "1 2 3");
   do
      export ALGORITHM=$variant
      build/Release/bencher/bencher "$INPUT" ./run.sh || exit 1;
   done
done