#include "JanMatcher.hpp"
#include "Pattern.hpp"
#include "StringHelper.hpp"
#include <iostream>
#include <cstring>
#include <vector>
#include <unordered_map>
#include <algorithm>
#include <atomic>
#include <chrono>
#include <thread>
#include <cassert>
#include <boost/functional/hash.hpp>


using namespace std;
using namespace std::experimental;

static inline void combineHash(uint64_t& totalHash, uint64_t wordHash){
//  boost::hash_combine(totalHash,wordHash);
totalHash ^= (totalHash<<4)+wordHash;
}

static inline unsigned nextPowOf2(unsigned ringBufSize){
  ringBufSize--;
  ringBufSize |= ringBufSize >> 1;
  ringBufSize |= ringBufSize >> 2;
  ringBufSize |= ringBufSize >> 4;
  ringBufSize |= ringBufSize >> 8;
  ringBufSize |= ringBufSize >> 16;
  return ++ringBufSize;
}

//====================================================================
/*static unsigned getNumWords(const string_view& nGram)
{
   unsigned count = 1;
   for(auto c : nGram){
     count += c == ' ';
   }
   return count;
}*/
//====================================================================
string_view firstWord(const string_view& s)noexcept{
    if(s.size() == 0){
        return s;
    }
    auto start = s.data();
    auto firstOcc = posOfFirstWhitespace(start);
    return string_view(start, firstOcc - start);
}
//====================================================================
string_view firstWords(const string_view& s, size_t lastEnd)noexcept{
    if(s.size() == 0){
        return s;
    }
    auto start = s.data();
    auto startSearch = s.data()+lastEnd;
    auto firstOcc = posOfFirstWhitespace(startSearch);
    return string_view(s.data(), firstOcc - start);
}
//====================================================================
void JanMatcher::remove(const string_view nG)noexcept
{
  uint64_t totalHash=0;
  string_view nGram(nG);
  nGram.remove_suffix(1);
  auto curPos=nGram.data();
  auto end = curPos+nGram.size();
  while(curPos<end){
    auto nextWord = posOfFirstWhitespace(curPos);
    auto length = nextWord-curPos;
    auto wordHash = hash(curPos, length);
    combineHash(totalHash,wordHash);
    curPos=nextWord+1;
  }
  WordInfo* wordInfo=nGrams.altFind(nGram,totalHash);
  if(wordInfo) wordInfo->version=0xFFFFFFFF;
}
static inline void setMax(uint32_t& a, uint64_t b) { a = a > b ? a : b;}
//====================================================================
void JanMatcher::add(const string_view ngram)noexcept
{
  const char* data;
  if(ngram.size()>Pattern::SHORT_STRING_LIMIT){
    //XXX memory leak if it already exists...
    char* loc = new char[ngram.size()];
    ngram.copy(loc, ngram.size());
    data =loc;
  } else{
    data=ngram.data();
  }


//  auto words = getNumWords(ngram);
  uint32_t characters = ngram.size()-1;

  const char* start = data;


  auto curPos=data;
  auto end = curPos+ngram.size();

  vector<uint32_t> patternLengths;
  vector<uint64_t> hashWords;
  patternLengths.reserve(characters);
  hashWords.reserve(characters);

  uint64_t totalHash=0;
  while(curPos<end){
    auto nextWord = posOfFirstWhitespace(curPos);
    patternLengths.push_back(nextWord-start);
    auto length = nextWord-curPos;

    auto wordHash = hash(curPos, length);
    combineHash(totalHash,wordHash);
    hashWords.push_back(totalHash);
    curPos=nextWord+1;
    nGrams.prefetchDir(totalHash);
  }

  WordInfo* curPattern=nullptr;

  int32_t words=patternLengths.size();
  int32_t n=words-1;
  curPattern = nGrams.tryInsert(string_view(data,patternLengths[n]),hashWords[n]);
  curPattern->version=version;

  for(--n; n >=0;--n){
   curPattern = nGrams.tryAltInsert(string_view(data,patternLengths[n]),hashWords[n]);
    if(!curPattern->longestSuffix){
      curPattern->longestSuffix=characters; 
    } else {
      //setMax(curPattern->longestSuffix,characters);
      break;
    }
  }
}
//====================================================================
void JanMatcher::query(string_view line)noexcept
{
  //increment version (visibility of query)
  version++;
  const char notFound[]="-1";
  const char lineEnd[]="\n";
  if(line.size() <=1) {
    fwrite(notFound, 1, 2, stdout);
    fwrite(lineEnd, 1, 1, stdout);
    return;
  }


  uint32_t outputPos=0;
  #pragma GCC diagnostic ignored "-Wvla"
  char output[OUTBUF_SIZE];
  #pragma GCC diagnostic pop

  const char* start = line.data();
  vector<const char*> words;
  vector<uint64_t> hashWords;
  words.reserve(INIT_SIZE_QUERY_VECTORS);
  hashWords.reserve(INIT_SIZE_QUERY_VECTORS);

  const char* end = start+line.size();

  //get word offsets and prefetch hash values
  words.push_back(start-1);
  for(auto curPos=start;curPos<end;){
    auto pos=firstWhitespace(curPos,end);
   // cout << "pos=" << pos << "|" << endl;
    auto length = pos-curPos;
    hashWords.push_back(hash(curPos,length));

    words.push_back(pos);
    curPos=pos+1;
  }
  const uint32_t lastOffset =words.size()-1;

  //match words
  for(uint32_t wordPos=0; wordPos < lastOffset;++wordPos){
    const char* wordStart=words[wordPos]+1;
    nGrams.prefetchDir(hashWords[wordPos+12]);
    nGrams.prefetchFirst(hashWords[wordPos+6]);
    //__builtin_prefetch(words[wordPos+10],0,1);

    //check for matching n-grams from 1..cur_max_n
    uint64_t totalHash=0;
    auto until = lastOffset-wordPos;
    for(uint32_t i =0; i<until;++i){
      auto wordEnd = words[wordPos+i+1];
      uint32_t length = wordEnd-wordStart;
      auto curWord = string_view(wordStart,length);
      uint64_t hashWord = hashWords[wordPos+i];
      combineHash(totalHash,hashWord);
      //cout << "curWord=" << curWord << "|" << (i+1) << endl;
      //find it
      auto ngram = nGrams.altFind(curWord,totalHash);
      if (ngram){
        if(ngram->version < version){
          if(outputPos+length>OUTBUF_SIZE-2){
            fwrite(output, 1, outputPos, stdout);
            outputPos=0;
          }
          memcpy(&output[outputPos],curWord.data(),length);
          outputPos+=length;
          output[outputPos++]='|';

          ngram->version=version;
        }
        //local_min_n = ngram->shortestSuffix;
        if(!ngram->longestSuffix) break;
      }
     if(!ngram) /*no (sub-) pattern found*/ break;
    }
  }



  bool matchesFound = outputPos>0;


  if(!matchesFound){
    memcpy(&output[outputPos],&notFound,sizeof(notFound)-1);
    outputPos+=3;
  }
  output[outputPos-1]='\n';
  fwrite(output, 1, outputPos, stdout);

}

//====================================================================
JanMatcher::JanMatcher() : nGrams{INIT_CAPACITY} {
}
//====================================================================
JanMatcher::~JanMatcher() {
}
