#!/bin/bash

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
cd "$DIR"

# variant of moritz matcher
read -r VARIANT<variant 
if [[ -n "$ALGORITHM" ]] ; then
   VARIANT=$ALGORITHM
fi

if [[ $# -eq 1 ]] ; then
   VARIANT="$1"
fi

if [[ $# -eq 1 ]] ; then
   VARIANT="$1"
fi



# binary in release dir to use
MORITZ_MATCHER="USEIT"
BIN='main'
if [[ $MORITZ_MATCHER ]] ; then
  >&2 echo "Benchmarking $VARIANT"
  rr record debug/driver/driver_runner "$VARIANT"
else
  rr record debug/impl/$BIN
fi
