#include "singlethreaded/ngramer.hpp"
#include "util/shared.hpp"
#include <algorithm>
#include <iostream>
#include <iterator>
#include <sstream>
#include <unordered_set>

void STNgramer::query(const BorrowedString& document, QueryOut& out)
{
   std::unordered_set<BorrowedString> found;
   auto length = document.size();

   size_t current = 0;
   for (; current < length; current++) {
      if (document[current] != ' ') {
         break;
      }
   }
   size_t next = current;

   while (current < length) {
      for (size_t i = current + 1; i < length; i++) {
         if (document[i] == ' ') {
            next = i;
            break;
         }
      }

      if (next == current) {
         next = length;
      }

      auto& index = ngrams[document[current]];
      auto before = index.lower_bound(document.substr(current, next - current).toOwnedRef());
      for (auto i = before; i != index.end(); i++) {
         const auto& value = i->first;
         auto comp = document.compare(current, value.size(), value);
         if (comp < 0) {
            break;
         }
         if (comp == 0 && ((document.size() == (current + value.size())) || (document[current + value.size()] == ' '))) {
            if (found.find(BorrowedString::refFromOwned(value)) == found.end()) {
               found.insert(BorrowedString::fromOwned(value));
               for (uint32_t j = 0; j < i->second; j++) {
                  out.addNgram(BorrowedString::refFromOwned(value));
               }
            }
         }
      }

      for (current = next + 1; current < length; current++) {
         if (document[current] != ' ') {
            break;
         }
      }
      next = current;
   }

   out.finishResult();
}


void STNgramer::add(const BorrowedString& ngram)
{
   auto owned = ngram.toOwned();
   ngrams[ngram[0]][std::move(owned)] += 1;
}

void STNgramer::remove(const BorrowedString& ngram) { ngrams[ngram[0]].erase(ngram.toOwnedRef()); }
