#pragma once

#include "campers/megahashtable.hpp"
#include "util/basengramer.hpp"
#include "util/hashtree.hpp"
#include "util/output.hpp"
#include "util/string.hpp"
#include <string>
#include <unordered_set>
#include <vector>

inline std::pair<BorrowedString, BorrowedString> SplitFn(const BorrowedString& value)
{
   auto splits = value.split(' ');
   if (splits.second.size() > 0) {
      return std::make_pair(BorrowedString(splits.first.data(), splits.first.size()),
                            BorrowedString(splits.second.data() + 1, splits.second.size() - 1));
   }
   else {
      return splits;
   }
}

class STHashTreeNgramer : public STBaseNgramer {
   std::vector<OwnedString> ngrams;
   HashTree<BorrowedString, decltype(SplitFn)> hashtree;
   campers::MegaHashMap<BorrowedString, char> found;

   public:
   STHashTreeNgramer() : ngrams(), hashtree(SplitFn), found() { found.grow(1024); }

   void query(const BorrowedString& document, QueryOut& out) override;
   void add(const BorrowedString& ngram) override;
   void remove(const BorrowedString& ngram) override;
   void finalizeLoading() override;
};