package de.mse.uebung1_extra.dice_game;

public class Main {

   public static void main(String[] args) {

      Dice dice = new Dice(3);
      Player player1 = new Player(0, "Rick", dice);
      Player player2 = new Player(1, "Morty", dice);
      Game game = new Game(player1, player2);

      playOneGame(player1, player2, game);
      playManyGames(player1, player2, game);
   }

   private static void playOneGame(Player player1, Player player2, Game game) {
      game.play();
      System.out.println(game.getWinner().getName() + "won.");
   }

   private static void playManyGames(Player player1, Player player2, Game game) {
      int[] winCounter = new int[2];

      for (int i = 0; i < 100000; i++) {
         game.reset();
         game.play();
         winCounter[game.getWinner().getId()]++;
      }

      System.out.println(player1.getName() + " won " + winCounter[0] + " times");
      System.out.println(player2.getName() + " won " + winCounter[1] + " times");
   }
}
