package de.mse.uebung1_extra.dice_game;

public class Game {

   private Player player1;
   private Player player2;

   public Game(Player player1, Player player2) {
      this.player1 = player1;
      this.player2 = player2;
   }

   public void play() {
      while (getWinner() == null) {
         doTurn();
      }
   }

   public void doTurn() {
      if (getWinner() != null)
         return;

      player1.doTurn();

      if (getWinner() != null)
         return;

      player2.doTurn();
   }

   public Player getWinner() {
      if (player1.hasWon())
         return player1;
      if (player2.hasWon())
         return player2;
      return null;
   }

   public void reset() {
      player1.reset();
      player2.reset();
   }
}
