package de.mse.blatt5.aufgabe2;

public class BinaryTreeNode<Value extends Comparable<Value>> {

   private Value value;
   private BinaryTreeNode<Value> leftChild;
   private BinaryTreeNode<Value> rightChild;

   public BinaryTreeNode(Value value) {
      this.value = value;
      this.leftChild = null;
      this.rightChild = null;
   }

   public boolean has(Value value) {
      int res = this.value.compareTo(value);

      if (res == 0) { // -> this.value == value
         return true;
      }

      if (res < 0) { // -> this.value < value
         if (rightChild == null) {
            return false;
         }
         return rightChild.has(value);
      } else { // -> this.value > value
         if (leftChild == null) {
            return false;
         }
         return leftChild.has(value);
      }
   }

   public void insert(Value value) {
      int res = this.value.compareTo(value);

      if (res == 0) { // -> this.value == value
         return;
      }

      if (res < 0) { // -> this.value < value
         if (rightChild == null) {
            rightChild = new BinaryTreeNode<Value>(value);
            return;
         }
         rightChild.insert(value);
      } else { // -> this.value > value
         if (leftChild == null) {
            leftChild = new BinaryTreeNode<Value>(value);
            return;
         }
         leftChild.insert(value);
      }
   }
}
