package de.mse.blatt5.aufgabe1;

import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

class MovieVoteSearch {

   PriorityQueue<Movie> priorityQueue;

   class MyComparator implements Comparator<Movie> {

      @Override
      public int compare(Movie o1, Movie o2) {
         return o1.votes - o2.votes;
      }
   }

   // Konstruktor
   public MovieVoteSearch() {
      // The priority queue needs to know how to compare movies
      // Here are a few different ways to specify how the comparision should be performed

      // Uses the compareTo implementation in the Movie class
      priorityQueue = new PriorityQueue<>();

      // Uses the comparator
      priorityQueue = new PriorityQueue<>(new MyComparator());

      // Uses the inline (anonymous) class comparator
      priorityQueue = new PriorityQueue<>(new Comparator<Movie>() {
         @Override
         public int compare(Movie o1, Movie o2) {
            return o1.votes - o2.votes;
         }
      });

      // Uses a lambda function (java 8 required)
      priorityQueue = new PriorityQueue<>((o1, o2) -> {
         return o1.votes - o2.votes;
      });
   }

   public void insertMovieWithVotes(int votes, Movie movie) {
      priorityQueue.add(movie);
   }

   public Movie getMovieWithFewestVotes() {
      return priorityQueue.peek();
   }

   // Dieser Client verwendet Ihre Implementierung
   public static void main(String[] args) {
      MovieVoteSearch movieSearch = new MovieVoteSearch();

      // Filme einfuegen
      List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
      for (Movie m : movies) {
         movieSearch.insertMovieWithVotes(m.votes, m);
      }

      // Punktzugriff
      Movie movie = movieSearch.getMovieWithFewestVotes();

      // Ausgabe
      System.out.println(movie);
   }
}