package de.mse.blatt5.aufgabe1;

import java.util.HashMap;
import java.util.List;

class MovieTitleSearch {

   HashMap<String, Movie> hashMap;

   // Konstruktor
   public MovieTitleSearch() {
      hashMap = new HashMap<>();
   }

   public void insertMovieForTitle(String title, Movie movie) {
      hashMap.put(title, movie);
   }

   public Movie getMovieForTitle(String title) {
      return hashMap.get(title);
   }

   // Dieser Client verwendet Ihre Implementierung
   public static void main(String[] args) {
      MovieTitleSearch movieSearch = new MovieTitleSearch();

      // Filme einfuegen
      List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
      for (Movie m : movies) {
         movieSearch.insertMovieForTitle(m.title, m);
      }

      // Punktzugriff
      Movie movie = movieSearch.getMovieForTitle("Pulp Fiction");

      // Ausgabe
      System.out.println(movie);
   }
}