package de.mse.blatt5.aufgabe1;

import java.util.HashMap;
import java.util.List;

class MovieRankSearch {

   HashMap<Integer, Movie> hashMap;

   // Konstruktor
   public MovieRankSearch() {
      hashMap = new HashMap<>();
   }

   public void insertMovieWithRank(int rank, Movie movie) {
      hashMap.put(rank, movie);
   }

   public Movie getMovieForRank(int rank) {
      return hashMap.get(rank);
   }

   // Dieser Client verwendet Ihre Implementierung
   public static void main(String[] args) {
      MovieRankSearch movieSearch = new MovieRankSearch();

      // Filme einfuegen
      List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
      for (Movie m : movies) {
         movieSearch.insertMovieWithRank(m.rank, m);
      }

      // Punktzugriff
      Movie movie = movieSearch.getMovieForRank(42);

      // Ausgabe
      System.out.println(movie);
   }
}