package de.mse.blatt5.aufgabe1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class MovieRangeSearch {

   TreeMap<Integer, List<Movie>> movies;

   // Konstruktor
   public MovieRangeSearch() {
      movies = new TreeMap<>();
   }

   public void insertMovieForYear(int year, Movie movie) {
      if (movies.containsKey(year)) {
         movies.get(year).add(movie);
      } else {
         ArrayList<Movie> list = new ArrayList<>();
         list.add(movie);
         movies.put(year, list);
      }
   }

   public Collection<Movie> getMoviesBetweenYears(int fromYear, int toYear) {
      ArrayList<Movie> result = new ArrayList<>();

      // Unpack
      Set<Map.Entry<Integer, List<Movie>>> entries = movies.subMap(fromYear, toYear).entrySet();
      for (Map.Entry<Integer, List<Movie>> entry : entries) {
         result.addAll(entry.getValue());
      }

      return result;
   }

   // Dieser Client verwendet Ihre Implementierung
   public static void main(String[] args) {
      MovieRangeSearch movieSearch = new MovieRangeSearch();

      // Filme einfuegen
      List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
      for (Movie m : movies) {
         movieSearch.insertMovieForYear(m.year, m);
      }

      // Bereichszugriff
      Collection<Movie> list = movieSearch.getMoviesBetweenYears(1950, 1959);

      // Ausgabe
      System.out.println("Filme zwischen 1950 und 1959:");
      for (Movie m : list) {
         System.out.println(m);
      }
   }
}