package de.mse.uebung5;

import java.util.ArrayList;

// WICHTIG: Dies ist kein Beispiel für schönen code ;)
public class HanoiPrinter {

   public static void print(IntStack a, IntStack b, IntStack c, int height) {
      ArrayList<Integer> aList = new ArrayList<Integer>();
      ArrayList<Integer> bList = new ArrayList<Integer>();
      ArrayList<Integer> cList = new ArrayList<Integer>();

      copyStackToList(aList, a, height);
      copyStackToList(bList, b, height);
      copyStackToList(cList, c, height);

      for (int i = 0; i < height; i++) {
         printTower(aList, i);
         printTower(bList, i);
         printTower(cList, i);
         System.out.println();
      }
   }

   private static void copyStackToList(ArrayList<Integer> aList, IntStack a, int height) {
      while (!a.empty()) {
         aList.add(a.pop());
      }
      for (int i = aList.size() - 1; i >= 0; i--) {
         a.push(aList.get(i));
      }
      while (aList.size() < height) {
         aList.add(0, null);
      }
   }

   private static void printTower(ArrayList<Integer> tower, int i) {
      if (tower.get(i) == null) {
         System.out.print("       |       ");
      } else {
         switch (tower.get(i)) {
            case 1:
               System.out.print("       1       ");
               break;
            case 2:
               System.out.print("      -2-      ");
               break;
            case 3:
               System.out.print("     --3--     ");
               break;
            case 4:
               System.out.print("    ---4---    ");
               break;
            case 5:
               System.out.print("   ----5----   ");
               break;
            default:
               System.out.print("   ++++" + tower.get(i) + "++++   ");
               break;
         }
      }
   }

   public static void main(String[] args) {
      IntStack a = new IntStack();
      IntStack b = new IntStack();
      IntStack c = new IntStack();

      a.push(3);
      a.push(2);
      a.push(1);

      System.out.println("----------------------------------------------------\n\n");
      print(a, b, c, 4);
      System.out.println("\n\n----------------------------------------------------");
   }
}
