public class Hanoi {
  // Anzahl der Scheiben
  private static final int SCHEIBEN = 5;
  // Die drei Felder
  static Stack feld1, feld2, feld3;

  // Ausfuehrbare main-Methode
  public static void main(String[] args) {
    // Lege die drei Felder an
    feld1 = new Stack();
    feld2 = new Stack();
    feld3 = new Stack();

    // Lege die Scheiben auf Feld 1
    for (int scheibe = SCHEIBEN; scheibe > 0; scheibe--) {
      feld1.push(scheibe);
    }

    // Verschiebe den Turm von Feld 1 ueber Feld 2 nach Feld 3
    move(SCHEIBEN, feld1, feld2, feld3);
  }

  // Verschiebe den Turm mit allen Scheiben kleiner als "scheibe" von 
  // "start" ueber "ablage" nach "ziel"
  public static void move(int scheibe, Stack start, Stack ablage, Stack ziel) {
    if (scheibe > 0) {
      // Verschiebe zuerst den auf der Scheibe liegenden Turm auf die Ablage
      move(scheibe-1, start, ziel, ablage);

      // Verschiebe die unterste Scheibe des Turms auf das Zielfeld
      ziel.push(start.pop());

      // Verschiebe den kleineren Turm von der Ablage auf das Zielfeld
      move(scheibe-1, ablage, start, ziel);
    }
  }
}