package de.mse.uebung5;

public class IntStack {

   private IntNode head;

   public IntStack() {
      this.head = null;
   }

   public void push(int element) {
      IntNode newElement = new IntNode(element, head);
      head = newElement;
   }

   public int pop() {
      // Catch empty stack
      if (empty()) {
         System.out.println("Error: Stack empty !!");
         System.exit(-1);
      }

      // Normal case
      int result = head.element;
      this.head = head.next;
      return result;
   }

   public boolean empty() {
      if (head == null) {
         return true;
      }
      return false;
   }

   public boolean contains(int val) {
      IntNode current = this.head;

      while (current != null) {
         if (current.element == val)
            return true;
         current = current.next;
      }

      return false;
   }

   public static void main(String[] args) {
      IntStack intStack = new IntStack();
      System.out.println("intStack.empty() = " + intStack.empty());
      System.out.println("intStack.contains(11) = " + intStack.contains(11));
      System.out.println("pushing 11 ...");
      intStack.push(11);
      System.out.println("intStack.contains(11) = " + intStack.contains(11));
      System.out.println("pushing 22 ...");
      intStack.push(22);
      System.out.println("intStack.contains(11) = " + intStack.contains(11));
      System.out.println("intStack.empty() = " + intStack.empty());
      System.out.println("intStack.pop() = " + intStack.pop());
      System.out.println("intStack.contains(11) = " + intStack.contains(11));
      System.out.println("intStack.pop() = " + intStack.pop());
      System.out.println("intStack.contains(11) = " + intStack.contains(11));
   }
}
