package de.mse.uebung5;

public class HanoiSolver {

   private final IntStack a;
   private final IntStack b;
   private final IntStack c;

   private final int discCount;

   public HanoiSolver(int discCount) {
      this.a = new IntStack();
      this.b = new IntStack();
      this.c = new IntStack();
      this.discCount = discCount;

      for (int i = discCount; i > 0; i--) {
         this.a.push(i);
      }
   }

   public void print() {
      HanoiPrinter.print(a, b, c, discCount + 1);
   }

   public void solve() {
      solveRec(a, c, b, discCount);
   }

   public void solveRec(IntStack start, IntStack target, IntStack buffer, int discs) {
      // End of recursion
      if (discs == 1) {
         int element = start.pop();
         target.push(element);
         return;
      }

      // Move top n-1 tower from start -> buffer
      solveRec(start, buffer, target, discs - 1);

      // Move bottom disc from start -> target
      int element = start.pop();
      target.push(element);

      // Move top n-1 tower from buffer -> target
      solveRec(buffer, target, start, discs - 1);
   }

   public static void main(String[] args) {
      HanoiSolver hanoiSolver = new HanoiSolver(5);
      hanoiSolver.print();
      hanoiSolver.solve();
      System.out.println("\n\n---------------------------------\n\n");
      hanoiSolver.print();
   }
}
