import java.lang.RuntimeException;

// Ausnahme, falls auf einem leeren Stack pop() 
// aufgerufen wird
class EmptyStackException extends RuntimeException {}

// Die Knoten der verketteten Liste
class Node {
  // Der in diesem Knoten gespeicherte Wert
  int value;
  // Der naechste Knoten
  Node next;
}

// Der Stack
public class Stack {
  // Referenz auf das oberste Element im Stack,
  // welches wiederum auf die darunter liegenden
  // Elemente verweist
  Node head;

  // Das oberste Element herunternehmen
  public int pop() {
    // Stack leer -> Ausnahme werfen
    if (head == null) {
      throw new EmptyStackException();
    }
    // Oberstes Element aktualisieren und dessen 
    // Wert zurueckgeben
    Node oldHead = head;
    head = head.next;
    return oldHead.value;
  }

  // Element oben auf den Stack legen
  public void push(int element) {
    Node newElement = new Node();
    newElement.value = element;
    newElement.next = head;
    head = newElement;
  }
}