package de.tu_muenchen.informatik.webkemper1.UniVerwaltung_wsdl;
import java.sql.*;
import javax.sql.DataSource;
import javax.naming.InitialContext;
/**
 * 
 * @author Martin Wimmer
 *
 * provides a simple static operation getLehrUmfangVonProfessor()
 * for querying the amount of lectures held by a certain professor
 */
public class InquireDB {

	/**
	 * create a connection to the uni- database and inquire the
	 * amount of lectures for a specified professor
   * 
   * exeption-handling is skipped for keeping the example concise
   * 
	 * @param profName the name of the professor
	 * @return the amount of lectures
	 */
	public static int getLehrUmfangVonProfessor(String profName) {
		int sumsws = 0;  

    // insert DB-connection information here:
    String driver = "";
    String conURL = "";
    String user = "";
    String pwd  = "";


		try {
			// connect to database:      
      Class.forName(driver);      
      Connection conn =	DriverManager.getConnection(conURL, user, pwd);      

      //post query:
			PreparedStatement stmt = conn.prepareStatement(
        "SELECT SUM( v.SWS ) AS SUMSWS "
        + "FROM uni.Vorlesungen v, uni.Professoren p "
        + "WHERE v.gelesenVon = p.PersNr "
        + "AND p.Name = ?");
      stmt.setString(1, profName);			
			ResultSet rset =	stmt.executeQuery();
			rset.next();					
			sumsws = java.lang.Integer.parseInt(rset.getString("SUMSWS"));
			// disconnect
			rset.close();
			stmt.close();
			conn.close();
		} catch (Exception e) {e.printStackTrace();}
		return sumsws;
	}
	


}
