/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.util.HexBin;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class HexBinaryDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2079;
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        byte[] decoded = HexBin.decode(content);
        if (decoded == null) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "hexBinary"});
        }
        return new XHex(decoded);
    }

    public int getDataLength(Object value) {
        return ((XHex)value).length();
    }

    private static final class XHex {
        final byte[] data;
        private String canonical;

        public XHex(byte[] data) {
            this.data = data;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = HexBin.encode(this.data);
            }
            return this.canonical;
        }

        public int length() {
            return this.data.length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XHex)) {
                return false;
            }
            int len = this.data.length;
            byte[] odata = ((XHex)obj).data;
            if (len != odata.length) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (this.data[i] != odata[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

