/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.functions.Function;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class XPath
implements Serializable {
    private Expression m_mainExp;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_mainExp.fixupVariables(vars, globalsSize);
    }

    public void setExpression(Expression exp) {
        this.m_mainExp = exp;
    }

    public SourceLocator getLocator() {
        return this.m_mainExp.m_slocator;
    }

    public void setLocator(SourceLocator l) {
        this.m_mainExp.setSourceLocator(l);
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type, ErrorListener errorListener) throws TransformerException {
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = exprString;
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator);
        if (0 == type) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (1 == type) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage(71, new Object[]{Integer.toString(type)}));
        }
        Expression expr = compiler.compile(0);
        this.setExpression(expr);
    }

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type) throws TransformerException {
        this(exprString, locator, prefixResolver, type, null);
    }

    public XPath(Expression expr) {
        this.setExpression(expr);
    }

    public XObject execute(XPathContext xctxt, Node contextNode, PrefixResolver namespaceContext) throws TransformerException {
        return this.execute(xctxt, xctxt.getDTMHandleFromNode(contextNode), namespaceContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject execute(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        xctxt.pushNamespaceContext(namespaceContext);
        xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
        XObject xobj = null;
        try {
            Exception e2;
            block6: {
                try {
                    xobj = this.m_mainExp.execute(xctxt);
                }
                catch (TransformerException te) {
                    te.setLocator(this.getLocator());
                    ErrorListener el = xctxt.getErrorListener();
                    if (null == el) throw te;
                    el.error(te);
                    Object var11_6 = null;
                    xctxt.popNamespaceContext();
                    xctxt.popCurrentNodeAndExpression();
                    return xobj;
                }
                catch (Exception e2) {
                    break block6;
                }
                Object var11_5 = null;
                xctxt.popNamespaceContext();
                xctxt.popCurrentNodeAndExpression();
                return xobj;
            }
            while (true) {
                block7: {
                    if (e2 instanceof WrappedRuntimeException) break block7;
                }
                e2 = ((WrappedRuntimeException)e2).getException();
            }
            String msg = e2.getMessage();
            msg = msg == null || msg.length() == 0 ? "Unknown error in XPath" : msg;
            TransformerException te = new TransformerException(msg, this.getLocator(), e2);
            ErrorListener el = xctxt.getErrorListener();
            if (null == el) throw te;
            el.fatalError(te);
            Object var11_7 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            return xobj;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean bool(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        block8: {
            block9: {
                xctxt.pushNamespaceContext(namespaceContext);
                xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
                try {
                    try {
                        var4_4 = this.m_mainExp.bool(xctxt);
                        var10_6 = null;
                        xctxt.popNamespaceContext();
                        xctxt.popCurrentNodeAndExpression();
                        return var4_4;
                    }
                    catch (TransformerException te) {
                        te.setLocator(this.getLocator());
                        el = xctxt.getErrorListener();
                        if (null == el) {
                            throw te;
                        }
                        el.error(te);
                        var10_7 = null;
                        xctxt.popNamespaceContext();
                        xctxt.popCurrentNodeAndExpression();
                        break block8;
                    }
                    catch (Exception e) {
                        ** while (e instanceof WrappedRuntimeException)
                    }
lbl-1000:
                    // 1 sources

                    {
                        e = ((WrappedRuntimeException)e).getException();
                        continue;
                    }
lbl25:
                    // 1 sources

                    msg = e.getMessage();
                    msg = msg == null || msg.length() == 0 ? "Unknown error in XPath" : msg;
                    te = new TransformerException(msg, this.getLocator(), e);
                    el = xctxt.getErrorListener();
                    if (null != el) {
                        el.fatalError(te);
                        break block9;
                    }
                    throw te;
                }
                catch (Throwable var9_16) {
                    var10_9 = null;
                    xctxt.popNamespaceContext();
                    xctxt.popCurrentNodeAndExpression();
                    throw var9_16;
                }
            }
            var10_8 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            {
            }
        }
        return false;
    }

    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.m_mainExp.execute(xctxt);
            double d = score.num();
            Object var7_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void installFunction(String name, int funcIndex, Function func) {
        FunctionTable.installFunction(func, funcIndex);
    }

    public void warn(XPathContext xctxt, int sourceNode, int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHWarning(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (null != ehandler) {
            ehandler.warning(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        }
    }

    public void assertion(boolean b, String msg) {
        if (!b) {
            String fMsg = XSLMessages.createXPATHMessage(30, new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    public void error(XPathContext xctxt, int sourceNode, int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (null != ehandler) {
            ehandler.fatalError(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        } else {
            SourceLocator slocator = xctxt.getSAXLocator();
            System.out.println(fmsg + "; file " + slocator.getSystemId() + "; line " + slocator.getLineNumber() + "; column " + slocator.getColumnNumber());
        }
    }
}

